<?php

require_once('config.php');

check_user();

check_activation(true);

require_once('classes/fb.php');
require_once('classes/user.php');
require_once('classes/schedules.php');

if(isset($_SESSION['activated'])){
    $activated = $_SESSION['activated'];
    unset($_SESSION['activated']);
}else{
    $activated = false;
}

$fb = new Facebook();

$user_class = new User();
$user = $user_class->get_user();

$schedule_class = new Schedules($user);

if(isset($_GET['code'])){
    $fb->save_fb_user();
}

$fb_user = $fb->get_fb_user();

$page = 'dashboard';


if(!$fb_user['user'] && $fb_user['loginUrl']){
    include('templates/dashboard_fb.php');
}elseif(!$fb_user['user'] && !$fb_user['loginUrl']){
    header('Location: '.baseUrl('settings.php'));
    die();
}else{
    if(!isset($_SESSION['new_data']))
        $new_data = array();
    else
        $new_data = $_SESSION['new_data'];

    $schedule = false;
    $save_keyword = '';
    $save_message = '';
    if(!empty($new_data['edit_id'])){
        if($schedule = $schedule_class->get_schedule($new_data['edit_id'])){
            $save_keyword = $schedule['keyword'];
            $save_message = $schedule['comment'];
        }
    }

    if(!isset($new_data['step0'])){
        include('templates/dashboard_step0.php');
    }elseif(!isset($new_data['step1'])){

        if($new_data['step0'] == 1) {
            $schedule_pages = $fb->get_fan_pages_list($user['fb_user_id'], $user['fb_token'], $user['fb_pages_limit']);
            include('templates/dashboard_step1.php');
        }
        else {
            $all_groups = array();
            $limit = $user['fb_pages_limit'];
            if($limit > LOAD_GROUPS)
                $limit = LOAD_GROUPS;

            $saved_groups = $fb->load_user_groups($user['id']);
            $limit = $limit - count($saved_groups);

            $fb_groups = array();
            if($limit > 0) {
                $fb_groups = $fb->get_groups_list($user['fb_user_id'], $user['fb_token'], $limit);
            }

            if(empty($saved_groups))
                $schedule_groups = $fb_groups;
            else{
                foreach($saved_groups as $group)
                {
                    if(count($schedule_groups['data']) >= LOAD_GROUPS)
                        break;

                    if($group_info = $fb->check_group_access($group->id,$user['fb_token'])){
                        $schedule_groups['data'][$group_info['id']] = array('id' => $group_info['id'],'name' => $group_info['name'], 'closed' => $group_info['closed']);
                    }
                }

                if(!empty($fb_groups['data']))
                    foreach($fb_groups['data'] as $group)
                    {
                        if(count($schedule_groups['data']) >= LOAD_GROUPS)
                            break;

                        $schedule_groups['data'][$group['id']] = array('id' => $group['id'], 'name' => $group['name'], 'closed' => $group['closed']);
                    }
            }

            if(!empty($schedule_groups['data']))
                foreach($schedule_groups['data'] as $key => $value)
                {
                    $all_groups[] = $value['id'];
                }

            $_SESSION['new_data']['all_groups'] = $all_groups;

            include('templates/dashboard_step1_1.php');
        }

    }elseif(!isset($new_data['step2'])){
        $posts_type = $new_data['step0'];
        include('templates/dashboard_step2.php');
    }elseif(!isset($new_data['step3'])){
        $condition_type = empty($new_data['step2']['condition_type']) ? 0 : $new_data['step2']['condition_type'];
        if($condition_type < 1 || $condition_type > 3){
            unset($_SESSION['new_data']);
            header('Location: '.baseUrl('dashboard.php'));
            die();
        }

        if($condition_type == 1 || isset($new_data['step2']['posts'])){
            include('templates/dashboard_step3.php');
        }elseif($condition_type == 2){

            $pages = $new_data['step1']['pages'];

            if(empty($pages)){
                unset($_SESSION['new_data']);
                header('Location: '.baseUrl('dashboard.php'));
                die();
            }

            if(isset($_SESSION['new_data']['all_posts'])){
                $_SESSION['new_data']['all_posts'] = array();
            }

            $all_posts = array();
            $posts_res = array();
            foreach($pages as $page_id){
                $only_owners = $new_data['step0'] == 1;
                $posts = $fb->getObjectPosts($page_id, $user['fb_token'], LOAD_POSTS, $only_owners, true, true);
                //echo"<pre>";print_r($posts);die();
                if(!empty($posts))
                    foreach($posts as $post){
                        $tmp = array();
                        $tmp['id']          = $post->id;

                        $link = explode('_',$post->id);

                        $tmp['link'] = 'https://www.facebook.com/' . (!empty($link[0]) ? $link[0] : "") . '/posts/' . (!empty($link[1]) ? $link[1] : "");

                        if(!empty($post->message))
                            $tmp['message']     = $post->message;
                        elseif(!empty($post->story))
                            $tmp['message']     = $post->story;
                        else
                            $tmp['message']     = "";

                        if(isset($post->picture))
                            $tmp['picture']     = $post->picture;
                        else
                            $tmp['picture']     = "https://graph.facebook.com/"  .$post->id. "/picture";

                        $tmp['from']            = !empty($post->from->name) ? $post->from->name : "";


                        if(!empty($post->comments->summary)){
                            $tmp['comments'] = $post->comments->summary->total_count;
                        }else{
                            $tmp['comments'] = 0;
                        }

                        if(!empty($post->likes->summary)){
                            $tmp['likes'] = $post->likes->summary->total_count;
                        }else{
                            $tmp['likes'] = 0;
                        }

                        /*
                        $comments_count     = $fb->get_object_comments_info($post->id, $user['fb_token']);
                        $likes_count        = $fb->get_object_likes_info($post->id, $user['fb_token']);
                        $tmp['comments']    = empty($comments_count->summary->total_count) ? 0 : $comments_count->summary->total_count;
                        $tmp['likes']       = empty($likes_count->summary->total_count) ? 0 : $likes_count->summary->total_count;
                        */
                        $tmp['created']     = empty($post->created_time) ? '' : $post->created_time;

                        $posts_res[] = $tmp;
                        $all_posts[] = $post->id;
                        if(count($posts_res) >= LOAD_POSTS) continue;
                    }
            }
            $pages_posts = $posts_res;
            $_SESSION['new_data']['all_posts'] = $all_posts;
            include('templates/dashboard_step3_1.php');
        }else{
            include('templates/dashboard_step4.php');
        }
    }elseif(!isset($new_data['step4'])){
        $condition      = empty($new_data['step2']['condition_type']) ? 0 : $new_data['step2']['condition_type'];
        $add_condition  = empty($new_data['step3']['add_condition']) ? 0 : $new_data['step3']['add_condition'];

        if($condition == 3 || $add_condition == 2){
            include('templates/dashboard_step4.php');
        }else{
            include('templates/dashboard_step4_1.php');
        }
    }elseif(!isset($new_data['step5'])){

        $schedule = false;
        if(!empty($new_data['edit_id'])){
            $schedule = $schedule_class->get_schedule($new_data['edit_id']);
        }

        $timestamp = $user_class->timestamp();
        $schedule_data['datefrom'] = date('m/d/Y', $timestamp);
        $schedule_data['timefrom'] = date('H:i', $timestamp);

        if(!$schedule) {
            $schedule_data['is_repeat']         = 0;
            $schedule_data['repeat_frequency']  = 4;
            $schedule_data['untildate']         = date('m/d/Y', $timestamp + 300);
            $schedule_data['untiltime']         = date('H:i', $timestamp + 300);
            $schedule_data['repeat_delay']      = 300;
            $schedule_data['auto_delete']       = 0;
            $schedule_data['delete_type']       = 1;
            $schedule_data['delete_after']      = 300;
            $schedule_data['deletedate']        = date('m/d/Y', $timestamp + 300);
            $schedule_data['deletetime']        = date('H:i', $timestamp + 300);
            $schedule_data['weekdays']          = array();
        }else{
            $schedule_data['is_repeat']         = $schedule['is_repeat'];
            $schedule_data['repeat_frequency']  = $schedule['repeat_frequency'];
            $schedule_data['untildate']         = date('m/d/Y', $schedule['end_timestamp']);
            $schedule_data['untiltime']         = date('H:i', $schedule['end_timestamp']);
            $schedule_data['repeat_delay']      = $schedule['repeat_interval'];
            $schedule_data['auto_delete']       = $schedule['auto_delete'];
            $schedule_data['delete_type']       = $schedule['delete_type'];
            $schedule_data['delete_after']      = $schedule['delete_interval'];
            $schedule_data['deletedate']        = date('m/d/Y', $schedule['delete_timestamp']);
            $schedule_data['deletetime']        = date('H:i', $schedule['delete_timestamp']);
            $schedule_data['weekdays']          = json_decode(html_entity_decode($schedule['repeat_weekdays']));
        }

        $schedule_data['frequency_types']   = array('1' => 'Daily', '2' => 'Weekly', '3' => 'Monthly', '4' => 'Custom');
        $schedule_data['delete_options']    = array('1' => 'After (seconds)', '2' => 'Select date and time');


        include('templates/dashboard_step5.php');
    }
}


/* prepare default values*/
/*
$schedule_pages_hide                    = true;
$schedule_pages['condition_type']       = 1;
$schedule_pages['keyword']              = "";
$schedule_pages['add_condition_type']   = 1;
$schedule_pages['add_keyword']          = "";
$schedule_pages['comment']              = "";
$schedule_pages['datefrom']             = date('m/d/Y',$user_class->timestamp());
$schedule_pages['timefrom']             = date('H:i',$user_class->timestamp());
$schedule_pages['dateend']              = date('m/d/Y',$user_class->timestamp());
$schedule_pages['timeend']              = date('H:i',$user_class->timestamp());
$schedule_pages['delete_date']          = date('m/d/Y',$user_class->timestamp()+300);
$schedule_pages['delete_time']          = date('H:i',$user_class->timestamp()+300);
$schedule_pages['selected_pages']       = array();
$schedule_pages['is_repeat']            = 0;
$schedule_pages['repeat_frequency']     = 4;
$schedule_pages['repeat_interval']      = 300;
$schedule_pages['frequency_weekly']     = array();
$schedule_pages['is_auto_delete']       = 0;
$schedule_pages['delete_type']          = 1;

if(isset($_POST['submit']) && $_POST['submit'] == 'set_schedule'){
    $post_data = $_POST;

    $result = $schedule_class->add($post_data, $fb_user['fb_user_name'], $fb_user['fb_token']);

    if(isset($result['success']) && $result['success']){
        header('Location: '.baseUrl('schedule.php'));
        die();
    }

    $schedule_pages['condition_type']       = empty($post_data['condition_type']) ? $schedule_pages['condition_type'] : $post_data['condition_type'];
    $schedule_pages['keyword']              = empty($post_data['keyword']) ? $schedule_pages['keyword'] : $post_data['keyword'];
    $schedule_pages['add_condition_type']   = empty($post_data['add_condition_type']) ? $schedule_pages['add_condition_type'] : $post_data['add_condition_type'];
    $schedule_pages['add_keyword']          = empty($post_data['add_keyword']) ? $schedule_pages['add_keyword'] : $post_data['add_keyword'];
    $schedule_pages['comment']              = empty($post_data['comment']) ? $schedule_pages['comment'] : $post_data['comment'];
    $schedule_pages['datefrom']             = empty($post_data['datefrom']) ? $schedule_pages['datefrom'] : $post_data['datefrom'];
    $schedule_pages['timefrom']             = empty($post_data['timefrom']) ? $schedule_pages['timefrom'] : $post_data['timefrom'];
    $schedule_pages['dateend']              = empty($post_data['until_date']) ? $schedule_pages['dateend'] : $post_data['until_date'];
    $schedule_pages['timeend']              = empty($post_data['until_time']) ? $schedule_pages['timeend'] : $post_data['until_time'];
    $schedule_pages['delete_date']          = empty($post_data['delete_date']) ? $schedule_pages['delete_date'] : $post_data['delete_date'];
    $schedule_pages['delete_time']          = empty($post_data['delete_time']) ? $schedule_pages['delete_time'] : $post_data['delete_time'];
    $schedule_pages['selected_pages']       = empty($post_data['pages']) ? $schedule_pages['selected_pages'] : $post_data['pages'];
    $schedule_pages['is_repeat']            = empty($post_data['is_repeat']) ? $schedule_pages['is_repeat'] : $post_data['is_repeat'];
    $schedule_pages['repeat_frequency']     = empty($post_data['repeat_frequency']) ? $schedule_pages['repeat_frequency'] : $post_data['repeat_frequency'];
    $schedule_pages['repeat_interval']      = empty($post_data['repeat_interval']) ? $schedule_pages['repeat_interval'] : $post_data['repeat_interval'];
    $schedule_pages['frequency_weekly']     = empty($post_data['frequency_weekly']) ? $schedule_pages['frequency_weekly'] : $post_data['frequency_weekly'];
    $schedule_pages['is_auto_delete']       = empty($post_data['is_auto_delete']) ? $schedule_pages['is_auto_delete'] : $post_data['is_auto_delete'];
    $schedule_pages['delete_type']          = empty($post_data['delete_type']) ? $schedule_pages['delete_type'] : $post_data['delete_type'];

    $schedule_pages['errors'][] = $result['errors'];
}

$user_timezone = $user_class->get_user_timezone();



if(!empty($schedule_pages['data']) && count($schedule_pages['data']) > 0 && count($schedule_pages['selected_pages']) > 0){
    $schedule_pages_hide = false;
}

include('templates/dashboard.php');
*/